#!/usr/bin/env python3

import os
import cgi, cgitb 
import subprocess
import random
import magic

def random_id():
	return str(random.randint(0, 2**32))

print("Content-type:text/plain\r\n\r\n")
try:
	form = cgi.FieldStorage()
	uploaded_file = form.getvalue('recording')
	
	filetype = magic.from_buffer(uploaded_file)

	# Write the file with the correct extension
	id = "/tmp/recording" + random_id()
	needs_convert = False
	if   "WAVE" in filetype:                        id += ".wav"
	elif "MPEG" in filetype and "III" in filetype:  id += ".mp3"
	else:                                           needs_convert = True
	with open(id, "wb") as f: f.write(uploaded_file)
	
	# Convert file to wav if it's not something Praat already knows how to handle
	if needs_convert:
		subprocess.check_output(["ffmpeg", "-i", id, id + ".wav"])
		id += ".wav"

	output = subprocess.check_output(
		["praat", "--run", "pitch-resonance.praat", id], universal_newlines=True
	)
	print(output)
except subprocess.CalledProcessError as e:
	print("CalledProcessError")
	print(e)
	print_code(str(e.output, 'utf-8'))
except Exception as e:
	print("Error")
	print_code(e)
